/***************************************************************/
//
//
//		RunningMan	[main.cpp]
//
//									Author	kazuki tanaka
//									Date	2016 04/18
/*---------------------------------------------------------------
Update : 2016/04/18
			bZ[W{bNX\
Update : 2016/04/25

Update : 2016/06/15
			FPS̕\

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

#include "main.h"
#include "input.h"
#include "polygon.h"
#include "player.h"
#include "bg.h"
#include "title.h"
#include "field.h"
#include "cube.h"
#include "sound.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/
/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/
#define CLASS_NAME "RunningMan"						//EBhENX̖O
#define WINDOW_NAME "RunningMan ver1.01"			//EBhE̖O

#define MODE_TITLE (000)
#define MODE_PLAY (001)

#define ID_TIMER (301)								//^C}[

#define TIMER_INTERVAL (1000/60)					//Ԋu601b

#define WIN_STYLE (WS_OVERLAPPEDWINDOW ^ WS_THICKFRAME ^ WS_MINIMIZEBOX ^ WS_MAXIMIZEBOX )
													//windoWIN_STYLẼ}N

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/

LRESULT CALLBACK WndProc(HWND hWnd,					//EBhEvV[W֐
UINT uMsg,WPARAM wParam,LPARAM lParam);

HRESULT Init(										//DirectX9̏ݒ
HINSTANCE hInstance,
HWND hWnd,
BOOL bWindow);

void UnInit(void);									//I
void Update( void );								//XV
void Draw ( void );									//ʂ̕`

#ifdef _DEBUG
void DrawFPS( void );								//FPS\p
#endif

/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3D9 g_pD3D=NULL;							//foCX쐬p

LPDIRECT3DDEVICE9 g_pD3DDevice=nullptr;				//Direct3DfoCXC^[tF[X̎擾

#ifdef _DEBUG
LPD3DXFONT g_pFont = nullptr;						//FPSEBhEɏނ߂̃C^[tF[X
#endif

int modeSelect = 0;									//[h̑I

int g_nCountFPS = 0;								//FPSJEgp


// Win32AvP[V
int APIENTRY WinMain(HINSTANCE hInstance,HINSTANCE hPravInstance,LPSTR IpCmdLine, int nCmdShow)
{


	UNREFERENCED_PARAMETER(hPravInstance);
	UNREFERENCED_PARAMETER(IpCmdLine);

	RECT cr = {0,0,SCREEN_WIDTH,SCREEN_HEIGHT};


	WNDCLASSEX wcex={
		sizeof(WNDCLASSEX),							//WNDCALSSEX̃TCYw
		CS_CLASSDC,									//\EBhẼX^Cݒ
		WndProc,									//  EBhEvV[W̃AhX(֐)w
		0,											//ʏ͎gpȂ̂"0"w
		0,											//ʏ͎gpȂ̂"0"wx
		hInstance,									//  WinMaiñp[^̃CX^Xnhݒ
		LoadIcon(hInstance, TEXT("KITTY")),			//gpACRw(WindowĂACRg)
		LoadCursor(NULL, IDC_CROSS),				//}EXJ[\w
		(HBRUSH)(COLOR_WINDOW + 1),					//EBhẼNCAg̈̔wiFݒ
		NULL,										//Windowsɂ郁j[ݒ
		CLASS_NAME,									//  EBhENX̖O
		NULL										//ACRݒ肳ꂽꍇ̏Lq
	};


	// EBhENX̓o^
	RegisterClassEx(&wcex);

	HWND hWnd;		//EBhEnh
	MSG msg;		

	AdjustWindowRect(&cr,WIN_STYLE,FALSE);

	int windowWidth = cr.right-cr.left;
	int windowHeight = cr.bottom-cr.top;

	RECT dr;

	GetWindowRect(GetDesktopWindow(),&dr);

	int dw = dr.right-dr.left;
	int dh = dr.bottom-dr.top;

	//int windowX = windowWidth>dw ? 0:dr.right;
	//int windowY = windowHeight>dh ? 0:dr.bottom;
	int windowX = windowWidth>dw ? 0:(dw-windowWidth)/2;
	int windowY = windowHeight>dh ? 0:(dh-windowHeight)/2;


	// EBhE쐬
	hWnd = CreateWindowEx(0,						//gEBhEX^C
	CLASS_NAME,										//EBhENX̖O
	WINDOW_NAME,									//EBhE̖O
	WIN_STYLE,										//EBhEX^C
	windowX,										//EBhE̍XW
	windowY,										//EBhE̍YW
	windowWidth,									//EBhE̕
	windowHeight,									//EBhE̍
	NULL,											//eEBhẼnh
	NULL,											//j[nh܂͎qEBhEID
	hInstance,										//CX^Xnh
	NULL);											//EBhE쐬f[^


	// EBhE̕\

	// EBhEnh
	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	// \̐ݒ
	timeBeginPeriod( 1 );

	// eJE^[̏
	DWORD dwFrameCount = 0;
	DWORD dwCurrentTime = 0;
	DWORD dwExecLastTime = timeGetTime();			//݂̎~bPʂŎ擾
	DWORD dwFPSLastTime = dwExecLastTime;			//Ԃ𓯊


	// ֐
	Init(hInstance,hWnd,true);

	// bZ\W[v
	for(;;){
	
		if(PeekMessage(&msg,NULL,0,0,PM_REMOVE)!=0){

			// EBhEY̏
			if(msg.message==WM_QUIT){
				break;
			}
			else{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
		else{

			dwCurrentTime = timeGetTime();		//݂̎~bPʂŎ擾
			
			if( (dwCurrentTime-dwFPSLastTime) >= 500 ){

				g_nCountFPS=(dwFrameCount*1000)/(dwCurrentTime-dwFPSLastTime);
				dwFPSLastTime = dwCurrentTime;
				dwFrameCount=0;
			
			}
			
			if( (dwCurrentTime - dwExecLastTime) >= ( TIMER_INTERVAL ) )
			{
				// DirectX̏
				dwExecLastTime=dwCurrentTime;	//Ԃۑ

				// [h̑I
				switch( modeSelect )
				{

					// ^Cg
					case MODE_TITLE:
						UpdateTitle();					//XV
						DrawTitle();					//`
						break;

					// vC
					case MODE_PLAY:
						Update();						//XV
						Draw();							//`
						break;

					default:
						MessageBox(NULL,"sȃ[hl܂","ERROR!!", MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2);			//^CvMB_OK̎Ɠ
						ChangeMode( MODE_TITLE );
						break;
				}

				dwFrameCount++;
			}
		}
	}

	// L[{[h
	UninitKeyboard();

	// TEhfoCX
	UninitSound();

	// I
	UnInit();
	UninitPolygon();
	UninitPlayer( );
	UninitTitle( );
	UninitField();

	timeEndPeriod( 1 );							// 1 ̐ݒ

	return (int)msg.wParam;						//֐0Ԃ

}

// EBhEvV[W
LRESULT CALLBACK WndProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{

	UINT nID;						//bZ[W̖߂l擾

	switch( uMsg )
	{

		case WM_CLOSE:				//EBhEj̃bZ[W
			
			nID=MessageBox(NULL,"I܂H","WM_CLOSE", MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2);

			if(nID==IDNO){
				uMsg=0;
			}
			break;

		case WM_DESTROY:

			PostQuitMessage(0);		//"WM_QUIT"bZ[WԂ

			break;

		case WM_CREATE:

			SetTimer(hWnd,ID_TIMER,TIMER_INTERVAL,NULL);		//^C}[̐ݒ
			
			break;

		case WM_COMMAND:

			break;

		case WM_PAINT:

			break;

		case WM_KEYDOWN:

			switch(wParam)
			{

				case VK_ESCAPE:

					nID=MessageBox(NULL,"I܂H","IbZ[W", MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2);			//^CvMB_OK̎Ɠ
					
					if(nID==IDYES){

						// EBhEI
						DestroyWindow(hWnd);			
					}
					break;

				case VK_SPACE:
										
					// [h̕ύX(^Cg̏I)
					ChangeMode( MODE_PLAY );

					break;

				default:
					break;
			}
			break;

		default:
			break;
	
	}

	return DefWindowProc(hWnd,uMsg,wParam,lParam);

}

// DirectX̏֐
HRESULT Init(HINSTANCE hInstance,HWND hWnd,BOOL bWindow)
{

	/* DirectX9̐ݒ()					*/
	/* IDirect3DDevice9C^[tF[X̎擾	*/


	D3DPRESENT_PARAMETERS d3dpp={0};			//foCX̓ݒ肷\
	D3DDISPLAYMODE d3ddm;						//fBXvC̐ݒ

	g_pD3D = Direct3DCreate9(D3D_SDK_VERSION);	//D3D9C^[tF[X̎擾
	if( g_pD3D==NULL ){
		return E_FAIL;
	}

	// ݂̃foCX[h̎擾
	if(FAILED(g_pD3D->GetAdapterDisplayMode(D3DADAPTER_DEFAULT,&d3ddm))){
		return E_FAIL;
	}

	// foCX̃v[e[Vp[^[̐ݒ
	ZeroMemory(&d3dpp,sizeof(d3dpp));

	d3dpp.BackBufferWidth=SCREEN_WIDTH;			//backbuffer̃TCY()
	d3dpp.BackBufferHeight=SCREEN_HEIGHT;		//backbuffer̃TCY(c)
	d3dpp.BackBufferFormat=d3ddm.Format;		//FULLSCREEN̂Ƃ͂̌ł͂ȂAWINDOWMODE͕
	d3dpp.BackBufferCount=1;					//backBuffer̐
	d3dpp.SwapEffect=D3DSWAPEFFECT_DISCARD;		//doubleBuffer̐؂ւ
	d3dpp.EnableAutoDepthStencil=TRUE;			//dv ;DepthStencil̎gp
	d3dpp.AutoDepthStencilFormat=D3DFMT_D16;	//D3DtH[}bg̐ݒ
	d3dpp.Windowed=bWindow;						//WindowMode trueŃEBhE falseFullScreen(WindoWIN_STYLEpopup)
	d3dpp.FullScreen_RefreshRateInHz
	=D3DPRESENT_RATE_DEFAULT;					//Xs[h(fullscreen̂Ƃ̂ݐݒ\)
	d3dpp.PresentationInterval
	=D3DPRESENT_INTERVAL_DEFAULT;				//fullscreen̎̂ 邩ǂ


	// Direct3DfoCX̐ݒ
	if(FAILED( g_pD3D->CreateDevice(
	D3DADAPTER_DEFAULT,							//ftHg̃A_v^[擾
	D3DDEVTYPE_HAL,								//`揈type̎w(n[hł邩\tgł邩)HAL=n[h
	hWnd,										//ǂ̃EBhȄɍ쐬邩(tH[JXEBhE)
	D3DCREATE_HARDWARE_VERTEXPROCESSING,		//foCX쐬IvVtO(̓n[hEFAŒ_)
	&d3dpp,										//̑ݒ
	&g_pD3DDevice)))							//foCX̃|C^̃|C^
	//sNULLԂ
	{

		MessageBox(hWnd,"x܂","",MB_OK);
		if(FAILED( g_pD3D->CreateDevice(
		D3DADAPTER_DEFAULT,							//ftHg̃A_v^[擾
		D3DDEVTYPE_HAL,								//`揈type̎w(n[hł邩\tgł邩)HAL=n[h
		hWnd,										//ǂ̃EBhȄɍ쐬邩(tH[JXEBhE)
		D3DCREATE_SOFTWARE_VERTEXPROCESSING,		//foCX쐬IvVtO(̓\tgEFAŒ_)
		&d3dpp,										//̑ݒ
		&g_pD3DDevice)))							//foCX̃|C^̃|C^
		{	

			if(FAILED( g_pD3D->CreateDevice(
			D3DADAPTER_DEFAULT,							//ftHg̃A_v^[擾
			D3DDEVTYPE_REF,								//`揈type̎w(n[hł邩\tgł邩)
			hWnd,										//ǂ̃EBhȄɍ쐬邩(tH[JXEBhE)
			D3DCREATE_SOFTWARE_VERTEXPROCESSING,		//foCX쐬IvVtO(̓\tgEFAŒ_)
			&d3dpp,										//̑ݒ
			&g_pD3DDevice)))							//foCX̃|C^̃|C^
			{
				return E_FAIL;
			}
		}
	}

	// _\Xe[g̐ݒ
	//g_pD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CW);			//v𗠖ʂƂ
	g_pD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW);			//v𗠖ʂƂ
	//g_pD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);		//ʂ`悷

	g_pD3DDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_SOLID);			//|Sŕ`
	//g_pD3DDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_WIREFRAME);	//|SC[t[ŕ`

	// ݉ʂɕ`ĂԂɂč`悷e
	g_pD3DDevice->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);			//
	g_pD3DDevice->SetRenderState(D3DRS_SRCBLEND,D3DBLEND_SRCALPHA);		//̃
	g_pD3DDevice->SetRenderState(D3DRS_DESTBLEND,D3DBLEND_INVSRCALPHA);	//̃(INV͋ẗӖ,ł̓l̋t)

	// Tv[Xe[g̐ݒ(stagesteat texturestate)
	g_pD3DDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);
	g_pD3DDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);

	g_pD3DDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_MIRROR);
	g_pD3DDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);
	//g_pD3DDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
	//g_pD3DDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);

	// L[{[h̏
	InitKeyboard( hInstance,hWnd );

	// TEh̐ݒ
	InitWaveSound(hWnd);

	// e֐̏
	InitPolygon( );
	InitPlayer( );
	InitTitle( );
	InitField( );
	InitCube( );

	#ifdef _DEBUG
	D3DXCreateFont( g_pD3DDevice,18,0,0,0,FALSE,
	SHIFTJIS_CHARSET,
	OUT_DEFAULT_PRECIS,
	DEFAULT_QUALITY,
	DEFAULT_PITCH,
	"terminal",&g_pFont );
	#endif	//_DEBUG

	//
	return S_OK;
	
}

// I
void UnInit(void)
{

	// Direct3DDeviceƃAhX̉
	SAFE_RELEASE(g_pD3DDevice)

	// Direect3DC^[tF[X̉
	SAFE_RELEASE(g_pD3D)

	// tHg\p̃C^[tF[X̊J
	#ifdef _DEBUG
	SAFE_RELEASE(g_pFont)
	#endif //_DEBUG

}

// XV
void Update( void )
{
	
	static unsigned int frame;		//Q[𐔂t[
	
	if(frame%12==0)
	{
		UpdateKeyboard( );
		UpdatePlayer( );
		UpdateTitle( );
		UpdateField( );
		//UpdateCube( );
	}

	frame++;

	// t[̃Zbg
	FRAME_RESET(frame,60)	

}

// `揈
void Draw ( void )
{

	// obNobt@Zobt@̃NA
	g_pD3DDevice->Clear(0,NULL,
	D3DCLEAR_TARGET								//F
	| D3DCLEAR_ZBUFFER,							//[x
	D3DCOLOR_RGBA(0,0,0,0),						//NAF
	1.0f,										//NA[xl
	0);											//XeVl

	// `̊Jn
	if(SUCCEEDED( g_pD3DDevice->BeginScene() ))
	{

		DrawBG( );
		DrawPlayer( );
		DrawField( );
		//DrawCube( );

		#ifdef _DEBUG
		DrawFPS();
		#endif	//_DEBUG

		// `I
		g_pD3DDevice->EndScene();

	}
	g_pD3DDevice->Present(NULL,NULL,NULL,NULL);


}

// FPS̕\
#ifdef _DEBUG
void DrawFPS( void )
{

	// FPS̕`O
	RECT rect={ 0,0,SCREEN_WIDTH,SCREEN_HEIGHT };

	char aStr[ 256 ];

	sprintf(&aStr[0],"FPS : %d ",g_nCountFPS);

	// FPS̕`揈
	g_pFont->DrawText(NULL,&aStr[0],-1,&rect,DT_LEFT,D3DCOLOR_RGBA(0,255,0,255));


}
#endif	//_DEBUG

// foCX̎擾
LPDIRECT3DDEVICE9 GetDevice(void)
{

	return g_pD3DDevice;

}

//[h̎擾
void ChangeMode( int mode )
{
	modeSelect = mode; 
}